<?php
// api.php
require_once 'db_functions.php';

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// دریافت action
$action = $_POST['action'] ?? $_GET['action'] ?? '';

if ($action == '') {
    echo json_encode(['success' => false, 'message' => 'Action required']);
    exit;
}

switch ($action) {
    case 'save_user':
        $user_id = $_POST['user_id'] ?? '';
        $gender = $_POST['gender'] ?? 'مرد';
        $peer_id = $_POST['peer_id'] ?? '';
        $status = $_POST['status'] ?? 'waiting';
        
        if (empty($user_id) || empty($peer_id)) {
            echo json_encode(['success' => false, 'message' => 'داده‌های ناقص']);
            break;
        }
        
        $room_id = saveOnlineUser($user_id, $gender, $peer_id, $status);
        
        if ($room_id) {
            echo json_encode(['success' => true, 'room_id' => $room_id]);
        } else {
            echo json_encode(['success' => false, 'message' => 'خطا در ذخیره']);
        }
        break;
        
    case 'find_partner':
        $user_id = $_POST['user_id'] ?? '';
        $gender = $_POST['gender'] ?? 'مرد';
        
        if (empty($user_id)) {
            echo json_encode(['success' => false, 'message' => 'شناسه کاربر نامعتبر']);
            break;
        }
        
        $partner = findPartnerForUser($user_id, $gender);
        
        if ($partner) {
            echo json_encode([
                'success' => true,
                'partner' => $partner
            ]);
        } else {
            echo json_encode([
                'success' => false,
                'message' => 'شریکی یافت نشد'
            ]);
        }
        break;
        
    case 'update_status':
        $user_id = $_POST['user_id'] ?? '';
        $status = $_POST['status'] ?? 'waiting';
        
        if (empty($user_id)) {
            echo json_encode(['success' => false]);
            break;
        }
        
        $result = updateUserStatus($user_id, $status);
        echo json_encode(['success' => $result]);
        break;
        
    case 'remove_user':
        $user_id = $_POST['user_id'] ?? '';
        
        if (empty($user_id)) {
            echo json_encode(['success' => false]);
            break;
        }
        
        $result = removeOnlineUser($user_id);
        echo json_encode(['success' => $result]);
        break;
        
    case 'end_call':
        $user_id = $_POST['user_id'] ?? '';
        $partner_id = $_POST['partner_id'] ?? '';
        
        if (empty($user_id) || empty($partner_id)) {
            echo json_encode(['success' => false]);
            break;
        }
        
        $result = endCall($user_id, $partner_id);
        echo json_encode(['success' => $result]);
        break;
        
    case 'get_stats':
        $stats = getStats();
        echo json_encode([
            'success' => true,
            'online_users' => $stats['online_users'],
            'active_calls' => $stats['active_calls'],
            'waiting_users' => $stats['waiting_users']
        ]);
        break;
        
    case 'get_online_users':
        $user_id = $_GET['user_id'] ?? $_POST['user_id'] ?? '';
        $users = getOnlineUsers($user_id);
        echo json_encode([
            'success' => true,
            'users' => $users
        ]);
        break;
        
    case 'send_message':
        $room_id = $_POST['room_id'] ?? '';
        $user_id = $_POST['user_id'] ?? '';
        $message = $_POST['message'] ?? '';
        
        if (empty($room_id) || empty($user_id) || empty($message)) {
            echo json_encode(['success' => false, 'message' => 'داده‌های ناقص']);
            break;
        }
        
        $result = saveChatMessage($room_id, $user_id, $message);
        echo json_encode(['success' => $result]);
        break;
        
    case 'get_messages':
        $room_id = $_GET['room_id'] ?? $_POST['room_id'] ?? '';
        $last_message_id = $_GET['last_message_id'] ?? $_POST['last_message_id'] ?? 0;
        
        if (empty($room_id)) {
            echo json_encode(['success' => false, 'message' => 'اتاق مشخص نشده']);
            break;
        }
        
        $messages = getChatMessages($room_id, $last_message_id);
        echo json_encode([
            'success' => true,
            'messages' => $messages
        ]);
        break;
        
    case 'cleanup':
        cleanupExpiredUsers();
        echo json_encode(['success' => true, 'message' => 'پاکسازی انجام شد']);
        break;
        
    default:
        echo json_encode(['success' => false, 'message' => 'Action نامعتبر']);
        break;
}
?>