<?php
// config.php - نسخه بدون مشکل session

// جلوگیری از نمایش خطا
error_reporting(0);
ini_set('display_errors', 0);

// تنظیمات دیتابیس
define('DB_HOST', 'localhost');
define('DB_USER', 'ffnuhf_mini');
define('DB_PASS', 'ffnuhf_mini');
define('DB_NAME', 'ffnuhf_mini');

// ایجاد اتصال به دیتابیس
function getDBConnection() {
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    
    if ($conn->connect_error) {
        return false;
    }
    
    $conn->set_charset("utf8mb4");
    return $conn;
}

// تولید شناسه یکتا برای کاربر (با کوکی)
function getOrCreateUserId() {
    if (isset($_COOKIE['user_id']) && !empty($_COOKIE['user_id'])) {
        return $_COOKIE['user_id'];
    }
    
    $user_id = 'user_' . uniqid() . '_' . rand(1000, 9999);
    setcookie('user_id', $user_id, time() + (86400 * 30), "/"); // 30 روز
    return $user_id;
}

// دریافت یا تنظیم جنسیت
function getOrCreateUserGender() {
    if (isset($_POST['gender'])) {
        $gender = ($_POST['gender'] == 'زن') ? 'زن' : 'مرد';
        setcookie('user_gender', $gender, time() + (86400 * 30), "/");
        return $gender;
    }
    
    if (isset($_COOKIE['user_gender']) && !empty($_COOKIE['user_gender'])) {
        return $_COOKIE['user_gender'];
    }
    
    return 'مرد'; // پیش‌فرض
}

// تنظیم متغیرهای کاربر
$user_id = getOrCreateUserId();
$user_gender = getOrCreateUserGender();

// تابع برای اطمینان از JSON
function json_response($data) {
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    exit;
}
?>