<?php
// config/database.php

// تنظیمات اتصال به دیتابیس
define('DB_HOST', 'localhost');
define('DB_NAME', 'ffnuhf_mini');
define('DB_USER', 'ffnuhf_mini');
define('DB_PASS', 'ffnuhf_mini');

/**
 * ایجاد اتصال به پایگاه داده
 * @return PDO
 */
function connectToDatabase() {
    try {
        $pdo = new PDO(
            "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4",
            DB_USER,
            DB_PASS,
            [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES => false,
                PDO::ATTR_PERSISTENT => false,
                // اضافه کردن این خط برای رفع مشکل unbuffered queries
                PDO::MYSQL_ATTR_USE_BUFFERED_QUERY => true
            ]
        );
        
        // تنظیمات کاراکترست برای پشتیبانی از فارسی
        $pdo->exec("SET NAMES utf8mb4");
        $pdo->exec("SET CHARACTER SET utf8mb4");
        $pdo->exec("SET time_zone = '+04:30'"); // زمان افغانستان
        
        return $pdo;
        
    } catch(PDOException $e) {
        // لاگ کردن خطا برای توسعه
        error_log("خطای اتصال دیتابیس: " . $e->getMessage());
        
        // پیام کاربر پسند
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            die(json_encode(['success' => false, 'message' => 'خطا در ارتباط با سرور. لطفاً مجدداً تلاش کنید.']));
        } else {
            die('<div style="text-align:center; padding:50px; font-family:Vazirmatn;">خطا در اتصال به پایگاه داده. لطفاً با مدیر سیستم تماس بگیرید.</div>');
        }
    }
}

// ایجاد اتصال و ذخیره در متغیر global
$pdo = connectToDatabase();
?>