<?php
// edit-profile.php
session_start();

// اگر کاربر لاگین نکرده باشد، به صفحه ورود هدایت شود
if (!isset($_SESSION['user_id'])) {
    header('Location: auth.php');
    exit;
}

require_once __DIR__ . '/config/database.php';

$user_id = $_SESSION['user_id'];
$message = '';
$success = false;

// دریافت اطلاعات کاربر فعلی
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = :id");
$stmt->execute(['id' => $user_id]);
$user = $stmt->fetch();

if (!$user) {
    session_destroy();
    header('Location: auth.php');
    exit;
}

// پردازش فرم ویرایش
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['edit_profile'])) {
    $first_name = trim($_POST['first_name'] ?? '');
    $username = trim($_POST['username'] ?? '');
    $email = $user['email']; // ایمیل غیرقابل ویرایش
    
    // اطلاعات جدید
    $birth_date = $_POST['birth_date'] ?? null;
    $gender = $_POST['gender'] ?? null;
    
    // اعتبارسنجی
    $errors = [];
    
    if (empty($first_name)) {
        $errors[] = 'نام الزامی است.';
    }
    
    if (empty($username)) {
        $errors[] = 'نام کاربری الزامی است.';
    }
    
    // بررسی تکراری بودن نام کاربری
    if (!empty($username) && $username != $user['username']) {
        $stmt = $pdo->prepare("SELECT id FROM users WHERE username = :username AND id != :id");
        $stmt->execute(['username' => $username, 'id' => $user_id]);
        if ($stmt->fetch()) {
            $errors[] = 'این نام کاربری قبلاً استفاده شده است.';
        }
    }
    
    // اعتبارسنجی تاریخ تولد
    if (!empty($birth_date)) {
        // تبدیل تاریخ از فرمت شمسی به میلادی (اگر نیاز است)
        // اگر تاریخ به فرمت میلادی وارد می‌شود:
        $birth_timestamp = strtotime($birth_date);
        
        // اعتبارسنجی تاریخ
        $min_date = strtotime('-100 years'); // حداکثر 100 سال سن
        $max_date = strtotime('-10 years'); // حداقل 10 سال سن
        
        if ($birth_timestamp === false) {
            $errors[] = 'تاریخ تولد نامعتبر است.';
        } elseif ($birth_timestamp > $max_date) {
            $errors[] = 'حداقل سن باید 10 سال باشد.';
        } elseif ($birth_timestamp < $min_date) {
            $errors[] = 'سن نمی‌تواند بیشتر از 100 سال باشد.';
        } else {
            // تبدیل به فرمت دیتابیس
            $birth_date = date('Y-m-d', $birth_timestamp);
        }
    } else {
        $birth_date = null;
    }
    
    // اعتبارسنجی جنسیت
    if (!empty($gender) && !in_array($gender, ['male', 'female', 'other'])) {
        $errors[] = 'جنسیت انتخاب شده معتبر نیست.';
    }
    
    if (empty($errors)) {
        // به‌روزرسانی اطلاعات در دیتابیس
        $stmt = $pdo->prepare("
            UPDATE users 
            SET first_name = :first_name, 
                username = :username,
                birth_date = :birth_date,
                gender = :gender,
                updated_at = NOW()
            WHERE id = :id
        ");
        
        $result = $stmt->execute([
            'first_name' => $first_name,
            'username' => $username,
            'birth_date' => $birth_date,
            'gender' => $gender,
            'id' => $user_id
        ]);
        
        if ($result) {
            // به‌روزرسانی سشن
            $_SESSION['first_name'] = $first_name;
            $_SESSION['username'] = $username;
            
            $message = 'اطلاعات پروفایل با موفقیت به‌روزرسانی شد.';
            $success = true;
            
            // دریافت اطلاعات به‌روز شده
            $stmt = $pdo->prepare("SELECT * FROM users WHERE id = :id");
            $stmt->execute(['id' => $user_id]);
            $user = $stmt->fetch();
        } else {
            $message = 'خطا در به‌روزرسانی اطلاعات. لطفاً مجدداً تلاش کنید.';
        }
    } else {
        $message = implode('<br>', $errors);
    }
}

// فرمت کردن تاریخ تولد برای نمایش در input
$display_birth_date = '';
if (!empty($user['birth_date']) && $user['birth_date'] != '0000-00-00') {
    $display_birth_date = date('Y-m-d', strtotime($user['birth_date']));
}
?>

<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="theme-color" content="#0088cc">
    <title>ویرایش پروفایل - <?= htmlspecialchars($user['first_name']) ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;500;600&display=swap');
        
        :root {
            --primary-color: #0088cc;
            --primary-dark: #0077b5;
            --bg-color: #f8f9fa;
            --card-bg: #ffffff;
            --text-primary: #212121;
            --text-secondary: #707579;
            --border-color: #e6e6e6;
            --error-color: #ff3b30;
            --success-color: #4cd964;
            --shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
            --radius: 16px;
            --male-color: #2196F3;
            --female-color: #E91E63;
            --other-color: #9C27B0;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            -webkit-tap-highlight-color: transparent;
        }
        
        html, body {
            height: 100%;
            width: 100%;
            font-family: 'Vazirmatn', sans-serif;
            background-color: var(--bg-color);
            color: var(--text-primary);
            font-size: 16px;
            line-height: 1.5;
        }
        
        .container {
            max-width: 100%;
            padding: 16px;
            margin: 0 auto;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }
        
        /* هدر */
        .header {
            display: flex;
            align-items: center;
            gap: 15px;
            padding: 20px 0;
            margin-bottom: 20px;
            border-bottom: 1px solid var(--border-color);
        }
        
        .back-btn {
            background: none;
            border: none;
            color: var(--primary-color);
            font-size: 20px;
            cursor: pointer;
            padding: 10px;
            border-radius: 50%;
            transition: background-color 0.2s;
        }
        
        .back-btn:hover {
            background-color: rgba(0, 136, 204, 0.1);
        }
        
        .page-title {
            font-size: 22px;
            font-weight: 600;
            color: var(--text-primary);
        }
        
        /* کارت فرم */
        .form-card {
            background-color: var(--card-bg);
            border-radius: var(--radius);
            padding: 24px;
            box-shadow: var(--shadow);
            border: 1px solid var(--border-color);
            flex: 1;
        }
        
        /* پیام */
        .message {
            padding: 12px 16px;
            border-radius: 10px;
            margin-bottom: 20px;
            font-size: 14px;
            display: flex;
            align-items: center;
            gap: 10px;
            animation: slideDown 0.3s ease;
        }
        
        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .message.error {
            background-color: rgba(255, 59, 48, 0.1);
            color: var(--error-color);
            border-right: 3px solid var(--error-color);
        }
        
        .message.success {
            background-color: rgba(76, 217, 100, 0.1);
            color: var(--success-color);
            border-right: 3px solid var(--success-color);
        }
        
        .message i {
            font-size: 16px;
        }
        
        /* فیلدهای فرم */
        .input-group {
            margin-bottom: 20px;
        }
        
        .input-label {
            display: block;
            margin-bottom: 8px;
            font-size: 14px;
            color: var(--text-secondary);
            font-weight: 500;
        }
        
        .required {
            color: var(--error-color);
            margin-right: 5px;
        }
        
        .input-field {
            width: 100%;
            padding: 14px;
            border: 1.5px solid var(--border-color);
            border-radius: 10px;
            font-size: 16px;
            font-family: 'Vazirmatn', sans-serif;
            background-color: white;
            transition: border-color 0.2s;
        }
        
        .input-field:focus {
            outline: none;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(0, 136, 204, 0.1);
        }
        
        .input-field.error {
            border-color: var(--error-color);
        }
        
        /* استایل برای فیلد غیرفعال */
        .input-field:read-only {
            background-color: #f9f9f9;
            border-color: #ddd;
            color: #666;
            cursor: not-allowed;
            padding-left: 45px;
        }
        
        .input-field:read-only:focus {
            border-color: #ddd;
            box-shadow: none;
        }
        
        /* استایل آیکون قفل */
        .lock-icon-container {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--text-secondary);
            pointer-events: none;
        }
        
        /* استایل توضیح */
        .field-note {
            display: block;
            margin-top: 8px;
            color: var(--text-secondary);
            font-size: 13px;
            line-height: 1.4;
        }
        
        .field-note i {
            margin-left: 5px;
            font-size: 12px;
        }
        
        /* کانتینر موقعیت نسبی برای آیکون */
        .input-with-icon {
            position: relative;
        }
        
        /* استایل‌های جدید برای جنسیت */
        .gender-group {
            display: flex;
            gap: 10px;
            margin-top: 8px;
            flex-wrap: wrap;
        }
        
        .gender-option {
            flex: 1;
            min-width: 120px;
        }
        
        .gender-input {
            display: none;
        }
        
        .gender-label {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            padding: 12px;
            border: 2px solid var(--border-color);
            border-radius: 10px;
            cursor: pointer;
            transition: all 0.3s;
            text-align: center;
            font-weight: 500;
        }
        
        .gender-label:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }
        
        .gender-input:checked + .gender-label {
            border-width: 3px;
        }
        
        .gender-input.male:checked + .gender-label {
            border-color: var(--male-color);
            background-color: rgba(33, 150, 243, 0.1);
            color: var(--male-color);
        }
        
        .gender-input.female:checked + .gender-label {
            border-color: var(--female-color);
            background-color: rgba(233, 30, 99, 0.1);
            color: var(--female-color);
        }
        
        .gender-input.other:checked + .gender-label {
            border-color: var(--other-color);
            background-color: rgba(156, 39, 176, 0.1);
            color: var(--other-color);
        }
        
        .gender-icon {
            font-size: 18px;
        }
        
        /* دکمه‌ها */
        .btn {
            padding: 14px 28px;
            border-radius: 10px;
            border: none;
            font-family: 'Vazirmatn', sans-serif;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.2s;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            text-decoration: none;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, var(--primary-color), var(--primary-dark));
            color: white;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 136, 204, 0.3);
        }
        
        .btn-outline {
            background-color: transparent;
            color: var(--primary-color);
            border: 2px solid var(--primary-color);
        }
        
        .btn-outline:hover {
            background-color: rgba(0, 136, 204, 0.1);
        }
        
        .btn-full {
            width: 100%;
            padding: 16px;
            margin-top: 10px;
        }
        
        /* فوتر */
        .footer {
            text-align: center;
            padding: 20px 0;
            color: var(--text-secondary);
            font-size: 14px;
            margin-top: 40px;
            border-top: 1px solid var(--border-color);
        }
        
        /* تاریخ تولد */
        .birth-date-group {
            position: relative;
        }
        
        .birth-date-group i {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--text-secondary);
            pointer-events: none;
        }
        
        .birth-date-group .input-field {
            padding-left: 45px;
        }
        
        /* رسپانسیو */
        @media (max-width: 768px) {
            .container {
                padding: 12px;
            }
            
            .form-card {
                padding: 20px 16px;
                border-radius: 12px;
            }
            
            .page-title {
                font-size: 20px;
            }
            
            .btn {
                padding: 12px 24px;
                font-size: 15px;
            }
            
            .input-field:read-only {
                padding-left: 40px;
            }
            
            .lock-icon-container {
                left: 12px;
            }
            
            .gender-group {
                flex-direction: column;
            }
            
            .gender-option {
                min-width: 100%;
            }
        }
        
        @media (max-width: 480px) {
            .container {
                padding: 8px;
            }
            
            .header {
                padding: 15px 0;
                margin-bottom: 15px;
            }
            
            .form-card {
                padding: 16px 12px;
                border-radius: 10px;
            }
            
            .input-field {
                padding: 12px;
                font-size: 15px;
            }
            
            .input-field:read-only {
                padding-left: 38px;
            }
            
            .btn-full {
                padding: 14px;
            }
            
            .field-note {
                font-size: 12px;
            }
            
            .gender-label {
                padding: 10px;
                font-size: 14px;
            }
        }
        
        /* حالت تاریک */
        @media (prefers-color-scheme: dark) {
            :root {
                --bg-color: #0f0f0f;
                --card-bg: #1a1a1a;
                --text-primary: #ffffff;
                --text-secondary: #a0a0a0;
                --border-color: #2a2a2a;
            }
            
            .input-field {
                background-color: #252525;
                color: white;
                border-color: #3a3a3a;
            }
            
            .input-field:read-only {
                background-color: #2a2a2a !important;
                border-color: #3a3a3a !important;
                color: #a0a0a0 !important;
            }
            
            .field-note {
                color: #888;
            }
            
            .gender-label {
                background-color: #252525;
                color: var(--text-primary);
            }
            
            .gender-input:checked + .gender-label {
                background-color: rgba(0, 136, 204, 0.2);
            }
        }
        
        /* استایل تقویم */
        input[type="date"]::-webkit-calendar-picker-indicator {
            filter: invert(0.5);
            cursor: pointer;
            margin-left: 10px;
        }
        
        @media (prefers-color-scheme: dark) {
            input[type="date"]::-webkit-calendar-picker-indicator {
                filter: invert(1);
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- هدر -->
        <div class="header">
            <button class="back-btn" onclick="goBack()">
                <i class="fas fa-arrow-right"></i>
            </button>
            <h1 class="page-title">ویرایش پروفایل</h1>
        </div>
        
        <!-- کارت فرم -->
        <div class="form-card">
            <?php if ($message): ?>
                <div class="message <?= $success ? 'success' : 'error' ?>">
                    <i class="fas <?= $success ? 'fa-check-circle' : 'fa-exclamation-circle' ?>"></i>
                    <span><?= htmlspecialchars($message) ?></span>
                </div>
            <?php endif; ?>
            
            <form method="POST" id="editProfileForm" onsubmit="return validateForm()">
                <input type="hidden" name="edit_profile" value="1">
                
                <div class="input-group">
                    <label class="input-label">
                        <span class="required">*</span>
                        نام
                    </label>
                    <input 
                        type="text" 
                        name="first_name" 
                        class="input-field" 
                        value="<?= htmlspecialchars($user['first_name']) ?>" 
                        required
                        maxlength="100"
                    >
                </div>
                
                <div class="input-group">
                    <label class="input-label">
                        <span class="required">*</span>
                        نام کاربری
                    </label>
                    <input 
                        type="text" 
                        name="username" 
                        class="input-field" 
                        value="<?= htmlspecialchars($user['username']) ?>" 
                        required
                        maxlength="50"
                        pattern="[a-zA-Z0-9_]+"
                        title="فقط حروف انگلیسی، اعداد و زیرخط مجاز است"
                    >
                </div>
                
                <div class="input-group">
                    <label class="input-label">
                        <span class="required">*</span>
                        آدرس ایمیل
                    </label>
                    <div class="input-with-icon">
                        <input 
                            type="email" 
                            name="email" 
                            class="input-field" 
                            value="<?= htmlspecialchars($user['email']) ?>" 
                            required
                            maxlength="100"
                            readonly
                        >
                        <div class="lock-icon-container">
                            <i class="fas fa-lock"></i>
                        </div>
                    </div>
                    <span class="field-note">
                        <i class="fas fa-info-circle"></i>
                        ایمیل شما قابل ویرایش نیست. برای تغییر ایمیل با پشتیبانی تماس بگیرید.
                    </span>
                </div>
                
                <!-- تاریخ تولد -->
                <div class="input-group">
                    <label class="input-label">
                        <i class="fas fa-birthday-cake" style="color: #FF9800; margin-left: 5px;"></i>
                        تاریخ تولد
                    </label>
                    <div class="birth-date-group">
                        <i class="fas fa-calendar-alt"></i>
                        <input 
                            type="date" 
                            name="birth_date" 
                            class="input-field" 
                            value="<?= htmlspecialchars($display_birth_date) ?>"
                            max="<?= date('Y-m-d', strtotime('-10 years')) ?>"
                            min="<?= date('Y-m-d', strtotime('-100 years')) ?>"
                        >
                    </div>
                    <span class="field-note">
                        <i class="fas fa-info-circle"></i>
                        سن باید بین 10 تا 100 سال باشد. این فیلد اختیاری است.
                    </span>
                </div>
                
                <!-- جنسیت -->
                <div class="input-group">
                    <label class="input-label">
                        <i class="fas fa-user" style="color: #4CAF50; margin-left: 5px;"></i>
                        جنسیت
                    </label>
                    <div class="gender-group">
                        <!-- مرد -->
                        <div class="gender-option">
                            <input 
                                type="radio" 
                                id="male" 
                                name="gender" 
                                value="male" 
                                class="gender-input male"
                                <?= ($user['gender'] ?? '') == 'male' ? 'checked' : '' ?>
                            >
                            <label for="male" class="gender-label">
                                <i class="fas fa-mars gender-icon"></i>
                                <span>مرد</span>
                            </label>
                        </div>
                        
                        <!-- زن -->
                        <div class="gender-option">
                            <input 
                                type="radio" 
                                id="female" 
                                name="gender" 
                                value="female" 
                                class="gender-input female"
                                <?= ($user['gender'] ?? '') == 'female' ? 'checked' : '' ?>
                            >
                            <label for="female" class="gender-label">
                                <i class="fas fa-venus gender-icon"></i>
                                <span>زن</span>
                            </label>
                        </div>
                        

                    </div>
                    <span class="field-note">
                        <i class="fas fa-info-circle"></i>
                        انتخاب جنسیت اختیاری است. برای حفظ حریم خصوصی می‌توانید خالی بگذارید.
                    </span>
                </div>
                
                <button type="submit" class="btn btn-primary btn-full" id="submitBtn">
                    <i class="fas fa-save"></i>
                    <span>ذخیره تغییرات</span>
                </button>
                
                <a href="dashboard.php" class="btn btn-outline btn-full" style="margin-top: 10px;">
                    <i class="fas fa-times"></i>
                    <span>انصراف</span>
                </a>
            </form>
        </div>
        
        <!-- فوتر -->
        <div class="footer">
            <p>ویرایش اطلاعات حساب کاربری شما</p>
            <p style="font-size: 12px; margin-top: 5px; color: #888;">
                ایمیل کاربر برای امنیت بیشتر غیرقابل ویرایش است
            </p>
        </div>
    </div>
    
    <script>
        // برگشت به صفحه قبل
        function goBack() {
            window.history.back();
        }
        
        // اعتبارسنجی فرم
        function validateForm() {
            const form = document.getElementById('editProfileForm');
            const submitBtn = document.getElementById('submitBtn');
            const originalText = submitBtn.innerHTML;
            
            // اعتبارسنجی تاریخ تولد
            const birthDateInput = document.querySelector('input[name="birth_date"]');
            if (birthDateInput.value) {
                const birthDate = new Date(birthDateInput.value);
                const today = new Date();
                const minDate = new Date();
                minDate.setFullYear(today.getFullYear() - 100); // 100 سال قبل
                const maxDate = new Date();
                maxDate.setFullYear(today.getFullYear() - 10); // 10 سال قبل
                
                if (birthDate > maxDate) {
                    alert('حداقل سن باید 10 سال باشد.');
                    birthDateInput.focus();
                    return false;
                }
                
                if (birthDate < minDate) {
                    alert('سن نمی‌تواند بیشتر از 100 سال باشد.');
                    birthDateInput.focus();
                    return false;
                }
            }
            
            // اعتبارسنجی اولیه
            if (!form.checkValidity()) {
                form.reportValidity();
                return false;
            }
            
            // تغییر وضعیت دکمه
            submitBtn.disabled = true;
            submitBtn.innerHTML = '<div class="loader"></div><span>در حال ذخیره...</span>';
            
            return true;
        }
        
        // جلوگیری از بزرگنمایی
        document.addEventListener('gesturestart', function(e) {
            e.preventDefault();
        });
        
        // مدیریت کلیدهای میانبر
        document.addEventListener('keydown', function(e) {
            // Ctrl+S یا Cmd+S برای ذخیره
            if ((e.ctrlKey || e.metaKey) && e.key === 's') {
                e.preventDefault();
                document.getElementById('editProfileForm').submit();
            }
            
            // Escape برای برگشت
            if (e.key === 'Escape') {
                goBack();
            }
        });
        
        // محاسبه سن بر اساس تاریخ تولد
        function calculateAge(birthDate) {
            if (!birthDate) return null;
            
            const today = new Date();
            const birth = new Date(birthDate);
            let age = today.getFullYear() - birth.getFullYear();
            const monthDiff = today.getMonth() - birth.getMonth();
            
            if (monthDiff < 0 || (monthDiff === 0 && today.getDate() < birth.getDate())) {
                age--;
            }
            
            return age;
        }
        
        // نمایش سن هنگام تغییر تاریخ تولد
        document.querySelector('input[name="birth_date"]').addEventListener('change', function(e) {
            const age = calculateAge(this.value);
            if (age !== null) {
                console.log('سن محاسبه شده:', age, 'سال');
                // می‌توانید این اطلاعات را در صفحه نمایش دهید
            }
        });
        
        // لودر CSS
        const style = document.createElement('style');
        style.textContent = `
            .loader {
                display: inline-block;
                width: 18px;
                height: 18px;
                border: 2px solid rgba(255, 255, 255, 0.3);
                border-top-color: white;
                border-radius: 50%;
                animation: spin 0.8s linear infinite;
            }
            
            @keyframes spin {
                to { transform: rotate(360deg); }
            }
            
            /* جلوگیری از انتخاب متن در فیلد ایمیل */
            input[readonly] {
                user-select: none;
                -webkit-user-select: none;
            }
            
            /* بهبود ظاهر تقویم در مرورگرهای مختلف */
            input[type="date"] {
                position: relative;
            }
            
            input[type="date"]::-webkit-inner-spin-button,
            input[type="date"]::-webkit-clear-button {
                display: none;
            }
            
            /* نمایش تاریخ به صورت فارسی (اختیاری) */
            .birth-date-group:after {
                content: attr(data-hint);
                position: absolute;
                right: 15px;
                top: 50%;
                transform: translateY(-50%);
                color: var(--text-secondary);
                font-size: 12px;
                pointer-events: none;
            }
        `;
        document.head.appendChild(style);
        
        // جلوگیری از تغییر ایمیل حتی با ابزارهای توسعه‌دهنده
        document.addEventListener('DOMContentLoaded', function() {
            const emailField = document.querySelector('input[name="email"]');
            
            // محافظت بیشتر در برابر تغییرات
            emailField.addEventListener('keydown', function(e) {
                e.preventDefault();
                return false;
            });
            
            emailField.addEventListener('input', function(e) {
                // بازگرداندن مقدار اصلی
                this.value = '<?= htmlspecialchars($user['email']) ?>';
            });
            
            emailField.addEventListener('change', function(e) {
                // بازگرداندن مقدار اصلی
                this.value = '<?= htmlspecialchars($user['email']) ?>';
            });
            
            // تنظیم محدودیت‌های تاریخ تولد
            const birthDateInput = document.querySelector('input[name="birth_date"]');
            const today = new Date();
            const minDate = new Date(today.getFullYear() - 100, today.getMonth(), today.getDate());
            const maxDate = new Date(today.getFullYear() - 10, today.getMonth(), today.getDate());
            
            // این بخش در HTML قبلاً تنظیم شده
        });
        
        // نمایش پیام تأیید برای حذف اطلاعات جنسیت
        document.querySelectorAll('.gender-input').forEach(function(radio) {
            radio.addEventListener('click', function(e) {
                // اگر قبلاً انتخاب شده بود و دوباره کلیک شود (برای لغو انتخاب)
                if (this.checked && this.dataset.wasChecked === 'true') {
                    if (confirm('آیا می‌خواهید جنسیت خود را پاک کنید؟')) {
                        this.checked = false;
                        this.dataset.wasChecked = 'false';
                    } else {
                        e.preventDefault();
                    }
                } else {
                    this.dataset.wasChecked = this.checked ? 'true' : 'false';
                }
            });
        });
    </script>
</body>
</html>