<?php
// get_online_users.php
require_once __DIR__ . '/config/database.php';

$stmt = $pdo->query("
    SELECT COUNT(*) as online_count 
    FROM users 
    WHERE is_online = 1 
    AND last_activity >= DATE_SUB(NOW(), INTERVAL 5 MINUTE)
");
$result = $stmt->fetch();

header('Content-Type: application/json');
echo json_encode([
    'online_count' => $result['online_count'],
    'timestamp' => date('Y-m-d H:i:s')
]);
?>