<?php
// dashboard.php
session_start();

// اگر کاربر لاگین نکرده باشد، به صفحه ورود هدایت شود
if (!isset($_SESSION['user_id'])) {
    header('Location: auth.php');
    exit;
}

require_once __DIR__ . '/config/database.php';

// دریافت اطلاعات کاربر از دیتابیس
$user_id = $_SESSION['user_id'];
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = :id");
$stmt->execute(['id' => $user_id]);
$user = $stmt->fetch();

if (!$user) {
    // اگر کاربر در دیتابیس پیدا نشد، از حساب خارج شود
    session_destroy();
    header('Location: auth.php');
    exit;
}

// به‌روزرسانی زمان آخرین ورود و وضعیت آنلاین
$pdo->prepare("UPDATE users SET last_login = NOW(), is_online = 1, last_activity = NOW() WHERE id = :id")
    ->execute(['id' => $user_id]);

// متغیرهای سشن را به‌روزرسانی کن
$_SESSION['username'] = $user['username'];
$_SESSION['first_name'] = $user['first_name'];
$_SESSION['email'] = $user['email'];

// بررسی وضعیت تکمیل پروفایل
$profile_complete = true;
$missing_fields = [];

if (empty($user['gender'])) {
    $profile_complete = false;
    $missing_fields[] = 'جنسیت';
}

// دریافت تعداد کاربران آنلاین (فعال در 5 دقیقه گذشته)
$online_users_stmt = $pdo->query("
    SELECT COUNT(*) as online_count 
    FROM users 
    WHERE is_online = 1 
    AND last_activity >= DATE_SUB(NOW(), INTERVAL 5 MINUTE)
");
$online_data = $online_users_stmt->fetch();
$online_users = $online_data['online_count'] ?? 0;

// تابع برای دریافت نماد بر اساس جنسیت
function getGenderIcon($gender) {
    switch($gender) {
        case 'male':
            return '<i class="fas fa-crown" style="color: #3b82f6;"></i>'; // آبی
        case 'female':
            return '<i class="fas fa-crown-queen" style="color: #ec4899;"></i>'; // صورتی
        case 'other':
            return '<i class="fas fa-user-circle" style="color: #8b5cf6;"></i>'; // بنفش
        default:
            return '<i class="fas fa-user" style="color: #9ca3af;"></i>'; // خاکستری
    }
}

// تابع برای دریافت URL تصویر آواتار بر اساس جنسیت
function getAvatarImage($gender) {
    if ($gender === 'female') {
        return 'https://entarpaltm.s2026h.space/mini/imoj/2.png'; // دختر
    } elseif ($gender === 'male') {
        return 'https://entarpaltm.s2026h.space/mini/imoj/1.png'; // پسر
    } else {
        // اگر جنسیت مشخص نیست یا other است
        return 'https://entarpaltm.s2026h.space/mini/imoj/1.png'; // پیش‌فرض پسر
    }
}

// تابع برای دریافت URL تصویر جایگزین
function getFallbackImage($gender) {
    return 'https://entarpaltm.s2026h.space/mini/imoj/1.png'; // همیشه تصویر پسر به عنوان جایگزین
}
?>

<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="theme-color" content="#7c3aed">
    <title>داشبورد - <?= htmlspecialchars($user['first_name']) ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;500;600;700&display=swap');
        
        :root {
            --primary: #7c3aed;
            --primary-light: #8b5cf6;
            --primary-dark: #6d28d9;
            --accent: #f59e0b;
            --danger: #ef4444;
            --success: #10b981;
            --bg: #0f172a;
            --card-bg: rgba(30, 41, 59, 0.7);
            --glass: rgba(255, 255, 255, 0.08);
            --glass-border: rgba(255, 255, 255, 0.15);
            --text: #f8fafc;
            --text-light: #cbd5e1;
            --shadow: 0 4px 24px rgba(0, 0, 0, 0.4);
            --radius: 16px;
            --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            -webkit-tap-highlight-color: transparent;
        }
        
        html, body {
            height: 100%;
            width: 100%;
            font-family: 'Vazirmatn', sans-serif;
            background: var(--bg);
            color: var(--text);
            font-size: 14px;
            line-height: 1.5;
            overflow-x: hidden;
        }
        
        body {
            background: linear-gradient(135deg, #0f172a 0%, #1e1b4b 100%);
            min-height: 100vh;
            padding-bottom: 80px;
        }
        
        /* انیمیشن‌ها */
        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(15px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        @keyframes colorChange {
            0% {
                background-position: 0% 50%;
            }
            50% {
                background-position: 100% 50%;
            }
            100% {
                background-position: 0% 50%;
            }
        }
        
        @keyframes glow {
            0%, 100% {
                filter: drop-shadow(0 0 8px var(--primary));
            }
            50% {
                filter: drop-shadow(0 0 15px var(--primary));
            }
        }
        
        @keyframes imageFadeIn {
            from {
                opacity: 0;
                transform: scale(0.9);
            }
            to {
                opacity: 1;
                transform: scale(1);
            }
        }
        
        @keyframes slideUp {
            from {
                transform: translateY(100px);
                opacity: 0;
            }
            to {
                transform: translateY(0);
                opacity: 1;
            }
        }
        
        /* استایل عمومی */
        .container {
            max-width: 100%;
            padding: 15px;
            margin: 0 auto;
        }
        
        @media (min-width: 768px) {
            .container {
                max-width: 750px;
            }
        }
        
        @media (min-width: 1024px) {
            .container {
                max-width: 980px;
            }
        }
        
        @media (min-width: 1280px) {
            .container {
                max-width: 1200px;
            }
        }
        
        .fade-in {
            animation: fadeIn 0.5s ease forwards;
        }
        
        /* دکمه پخش زنده مستطیل بزرگ */
        .live-stream-wrapper {
            text-align: center;
            margin: 25px auto 35px;
        }
        
        .live-stream-rectangle {
            position: relative;
            width: 100%;
            max-width: 500px;
            height: 120px;
            border-radius: 20px;
            background: linear-gradient(
                135deg, 
                #7c3aed, 
                #8b5cf6, 
                #ec4899, 
                #f59e0b, 
                #10b981, 
                #3b82f6
            );
            background-size: 400% 400%;
            border: none;
            color: white;
            cursor: pointer;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            gap: 8px;
            margin: 0 auto;
            transition: var(--transition);
            animation: colorChange 8s ease infinite, glow 2s infinite;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(124, 58, 237, 0.4);
        }
        
        @media (max-width: 640px) {
            .live-stream-rectangle {
                height: 100px;
                border-radius: 15px;
            }
        }
        
        .live-stream-rectangle.disabled {
            opacity: 0.6;
            cursor: not-allowed;
            animation: none;
            background: linear-gradient(135deg, #4b5563, #6b7280);
        }
        
        .live-stream-rectangle.disabled:hover {
            transform: none;
        }
        
        .live-stream-rectangle::before {
            content: '';
            position: absolute;
            width: 100%;
            height: 100%;
            background: radial-gradient(circle, transparent 30%, rgba(255,255,255,0.15) 70%);
            opacity: 0;
            transition: var(--transition);
        }
        
        .live-stream-rectangle:not(.disabled):hover::before {
            opacity: 1;
        }
        
        .live-stream-rectangle:not(.disabled):hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 40px rgba(124, 58, 237, 0.6);
        }
        
        .live-stream-rectangle i {
            font-size: 36px;
            position: relative;
            z-index: 1;
            margin-bottom: 5px;
        }
        
        .live-stream-rectangle .live-text {
            font-size: 22px;
            font-weight: 700;
            position: relative;
            z-index: 1;
            letter-spacing: 1px;
        }
        
        .live-stream-rectangle .online-count {
            position: absolute;
            top: 15px;
            left: 20px;
            background: rgba(255, 255, 255, 0.2);
            backdrop-filter: blur(10px);
            border-radius: 20px;
            padding: 6px 15px;
            font-size: 13px;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 8px;
            border: 1px solid rgba(255, 255, 255, 0.3);
        }
        
        .live-stream-rectangle .online-count i {
            font-size: 12px;
            margin-bottom: 0;
            color: #10b981;
        }
        
        .live-badge {
            position: absolute;
            top: 15px;
            right: 20px;
            width: 12px;
            height: 12px;
            background: var(--danger);
            border-radius: 50%;
            animation: colorChange 2s infinite;
        }
        
        /* بخش اطلاعات کاربر */
        .user-section {
            margin: 30px auto;
        }
        
        .user-profile-compact {
            display: flex;
            align-items: center;
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .user-avatar-circle {
            width: 90px;
            height: 90px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            border: 3px solid rgba(255, 255, 255, 0.2);
            box-shadow: var(--shadow);
            overflow: hidden;
            background: transparent;
        }
        
        @media (max-width: 640px) {
            .user-avatar-circle {
                width: 80px;
                height: 80px;
            }
        }
        
        .user-avatar-circle .avatar-image {
            width: 100%;
            height: 100%;
            object-fit: cover;
            border-radius: 50%;
            animation: imageFadeIn 0.8s ease forwards;
            transition: var(--transition);
            background-color: rgba(255, 255, 255, 0.1);
        }
        
        .user-avatar-circle:hover .avatar-image {
            transform: scale(1.05);
        }
        
        .user-avatar-circle .crown {
            position: absolute;
            top: -15px;
            font-size: 24px;
            filter: drop-shadow(0 2px 4px rgba(0,0,0,0.3));
            z-index: 2;
        }
        
        .user-info-header {
            flex: 1;
        }
        
        .user-name {
            font-size: 22px;
            font-weight: 700;
            margin-bottom: 5px;
            background: linear-gradient(45deg, var(--primary-light), white);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        
        .user-username {
            font-size: 15px;
            color: var(--text-light);
        }
        
        /* هشدار تکمیل پروفایل */
        .profile-warning {
            background: linear-gradient(135deg, rgba(245, 158, 11, 0.2), rgba(245, 158, 11, 0.1));
            border: 1px solid rgba(245, 158, 11, 0.3);
            border-radius: var(--radius);
            padding: 15px;
            margin-bottom: 20px;
            display: <?= $profile_complete ? 'none' : 'flex' ?>;
            align-items: center;
            gap: 12px;
            animation: fadeIn 0.5s ease;
        }
        
        .profile-warning i {
            color: var(--accent);
            font-size: 20px;
        }
        
        .profile-warning-content {
            flex: 1;
        }
        
        .profile-warning-title {
            font-weight: 600;
            margin-bottom: 5px;
            color: var(--accent);
        }
        
        .profile-warning-text {
            font-size: 13px;
            color: var(--text-light);
            line-height: 1.4;
        }
        
        .complete-profile-btn {
            background: var(--accent);
            color: white;
            border: none;
            padding: 8px 16px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
            white-space: nowrap;
        }
        
        .complete-profile-btn:hover {
            background: #f97316;
            transform: translateY(-2px);
        }
        
        /* ساختار جدید کارت‌ها */
        .info-grid-new {
            display: grid;
            grid-template-columns: 1fr;
            gap: 15px;
        }
        
        .info-row-three {
            display: grid;
            grid-template-columns: 1fr 1fr 1fr;
            gap: 15px;
        }
        
        .info-row-two {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 15px;
        }
        
        @media (max-width: 768px) {
            .info-row-three {
                grid-template-columns: 1fr;
            }
            
            .info-row-two {
                grid-template-columns: 1fr;
            }
        }
        
        .info-card-small {
            background: var(--card-bg);
            backdrop-filter: blur(10px);
            border-radius: 12px;
            padding: 18px;
            border: 1px solid var(--glass-border);
            transition: var(--transition);
            min-height: 110px;
            display: flex;
            flex-direction: column;
        }
        
        .info-card-small:hover {
            transform: translateY(-3px);
            border-color: var(--primary);
        }
        
        .info-header {
            display: flex;
            align-items: center;
            gap: 10px;
            margin-bottom: 12px;
        }
        
        .info-icon {
            width: 36px;
            height: 36px;
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 16px;
            color: white;
        }
        
        .info-icon.purple {
            background: linear-gradient(135deg, var(--primary), var(--primary-light));
        }
        
        .info-icon.blue {
            background: linear-gradient(135deg, #3b82f6, #60a5fa);
        }
        
        .info-icon.green {
            background: linear-gradient(135deg, var(--success), #34d399);
        }
        
        .info-icon.orange {
            background: linear-gradient(135deg, var(--accent), #fbbf24);
        }
        
        .info-icon.pink {
            background: linear-gradient(135deg, #ec4899, #f472b6);
        }
        
        .info-icon.teal {
            background: linear-gradient(135deg, #06b6d4, #22d3ee);
        }
        
        .info-icon.red {
            background: linear-gradient(135deg, #ef4444, #f87171);
        }
        
        .info-icon.yellow {
            background: linear-gradient(135deg, #eab308, #fde047);
        }
        
        .info-title {
            font-size: 13px;
            color: var(--text-light);
            flex: 1;
        }
        
        .info-value {
            font-size: 16px;
            font-weight: 600;
            line-height: 1.4;
            margin-top: auto;
        }
        
        /* کارت‌های آمار */
        .stats-grid-new {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 15px;
            margin-top: 25px;
        }
        
        @media (max-width: 640px) {
            .stats-grid-new {
                grid-template-columns: 1fr;
            }
        }
        
        .stat-card-small {
            background: var(--card-bg);
            backdrop-filter: blur(10px);
            border-radius: 12px;
            padding: 20px;
            text-align: center;
            border: 1px solid var(--glass-border);
        }
        
        .stat-card-small i {
            font-size: 24px;
            margin-bottom: 10px;
            color: var(--primary);
        }
        
        .stat-number-small {
            font-size: 20px;
            font-weight: 700;
            margin: 8px 0;
            color: var(--text);
        }
        
        .stat-text-small {
            font-size: 12px;
            color: var(--text-light);
        }
        
        /* نوار ابزار پایین - همیشه ثابت */
        .bottom-toolbar-fixed {
            position: fixed;
            bottom: 0;
            left: 0;
            width: 100%;
            background: rgba(15, 23, 42, 0.95);
            backdrop-filter: blur(20px);
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            padding: 12px 15px;
            display: flex;
            justify-content: space-around;
            align-items: center;
            z-index: 1000;
            box-shadow: 0 -4px 20px rgba(0, 0, 0, 0.3);
            animation: slideUp 0.3s ease;
        }
        
        .toolbar-btn-fixed {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            background: transparent;
            border: none;
            color: var(--text-light);
            padding: 8px 12px;
            border-radius: 40px;
            cursor: pointer;
            transition: var(--transition);
            min-width: 80px;
        }
        
        @media (max-width: 640px) {
            .toolbar-btn-fixed {
                min-width: 70px;
                padding: 6px 10px;
            }
        }
        
        .toolbar-btn-fixed:hover {
            color: var(--text);
            transform: translateY(-3px);
        }
        
        .toolbar-btn-fixed.active {
            background: rgba(124, 58, 237, 0.2);
            color: var(--primary);
        }
        
        .toolbar-btn-fixed i {
            font-size: 18px;
            margin-bottom: 4px;
        }
        
        .toolbar-btn-fixed span {
            font-size: 11px;
            font-weight: 500;
        }
        
        .toolbar-btn-fixed.logout {
            color: var(--danger);
        }
        
        .toolbar-btn-fixed.logout:hover {
            background: rgba(239, 68, 68, 0.1);
        }
        
        /* فوتر */
        .footer-small {
            text-align: center;
            padding: 25px 15px 100px 15px;
            color: var(--text-light);
            font-size: 12px;
        }
        
        .user-id {
            display: inline-block;
            background: rgba(124, 58, 237, 0.2);
            padding: 4px 12px;
            border-radius: 20px;
            margin-top: 8px;
            font-size: 11px;
            color: var(--primary-light);
        }
        
        /* اسکرول بار */
        ::-webkit-scrollbar {
            width: 8px;
        }
        
        ::-webkit-scrollbar-track {
            background: rgba(30, 41, 59, 0.5);
            border-radius: 4px;
        }
        
        ::-webkit-scrollbar-thumb {
            background: linear-gradient(135deg, var(--primary), var(--primary-light));
            border-radius: 4px;
        }
        
        ::-webkit-scrollbar-thumb:hover {
            background: linear-gradient(135deg, var(--primary-dark), var(--primary));
        }
        
        /* رسپانسیو */
        @media (max-width: 640px) {
            .container {
                padding: 12px;
            }
            
            .user-profile-compact {
                flex-direction: column;
                text-align: center;
                gap: 15px;
            }
            
            .live-stream-rectangle {
                height: 90px;
                border-radius: 15px;
            }
            
            .live-stream-rectangle .live-text {
                font-size: 18px;
            }
            
            .live-stream-rectangle i {
                font-size: 28px;
            }
            
            .info-card-small {
                padding: 15px;
                min-height: 100px;
            }
            
            .info-value {
                font-size: 15px;
            }
            
            .bottom-toolbar-fixed {
                padding: 10px 5px;
            }
            
            .toolbar-btn-fixed i {
                font-size: 16px;
            }
            
            .toolbar-btn-fixed span {
                font-size: 10px;
            }
            
            .profile-warning {
                flex-direction: column;
                text-align: center;
            }
        }
        
        @media (min-width: 641px) and (max-width: 1024px) {
            .container {
                padding: 20px;
            }
            
            .info-grid-new {
                gap: 20px;
            }
            
            .info-row-three, .info-row-two {
                gap: 20px;
            }
        }
        
        /* حالت لودینگ تصویر */
        .avatar-image.loading {
            filter: blur(5px);
        }
        
        /* حالت خطا در بارگذاری تصویر */
        .avatar-fallback {
            width: 100%;
            height: 100%;
            background: linear-gradient(135deg, var(--primary), var(--accent));
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 32px;
            font-weight: bold;
            color: white;
            border-radius: 50%;
        }
        
        /* اسپیس برای نوار ابزار ثابت */
        .toolbar-spacer {
            height: 80px;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- هشدار تکمیل پروفایل -->
        <?php if (!$profile_complete): ?>
        <div class="profile-warning fade-in">
            <i class="fas fa-exclamation-triangle"></i>
            <div class="profile-warning-content">
                <div class="profile-warning-title">تکمیل پروفایل</div>
                <div class="profile-warning-text">
                    برای شروع پخش زنده، لطفا اطلاعات زیر را تکمیل کنید:
                    <?= implode('، ', $missing_fields) ?>
                </div>
            </div>
            <button class="complete-profile-btn" onclick="window.location.href='edit-profile.php'">
                تکمیل پروفایل
            </button>
        </div>
        <?php endif; ?>
        
        <!-- دکمه پخش زنده مستطیل بزرگ -->
        <div class="live-stream-wrapper fade-in">
            <button class="live-stream-rectangle <?= !$profile_complete ? 'disabled' : '' ?>" 
                    onclick="<?= $profile_complete ? 'startLiveStream()' : 'showProfileWarning()' ?>">
                <div class="online-count">
                    <i class="fas fa-user-friends"></i>
                    <span id="online-counter"><?= $online_users ?> کاربر آنلاین</span>
                </div>
                <div class="live-badge"></div>
                <i class="fas fa-video"></i>
                <span class="live-text">پخش زنده</span>
            </button>
        </div>
        
        <!-- بخش اطلاعات کاربر -->
        <div class="user-section fade-in">
            <!-- هدر کاربر -->
            <div class="user-profile-compact">
                <div class="user-avatar-circle">
                    <div class="crown">
                        <?= getGenderIcon($user['gender'] ?? '') ?>
                    </div>
                    <img id="avatar-image" 
                         src="<?= getAvatarImage($user['gender'] ?? '') ?>" 
                         alt="آواتار <?= htmlspecialchars($user['first_name']) ?>"
                         class="avatar-image"
                         onerror="handleImageError()">
                </div>
                <div class="user-info-header">
                    <div class="user-name">
                        <?= htmlspecialchars($user['first_name']) . ' ' . htmlspecialchars($user['last_name'] ?? '') ?>
                    </div>
                    <div class="user-username">
                        @<?= htmlspecialchars($user['username']) ?>
                    </div>
                </div>
            </div>
            
            <!-- کارت‌های اطلاعات جدید -->
            <div class="info-grid-new">
                <!-- ردیف اول: نام کامل + نام کاربری + ایمیل -->
                <div class="info-row-three">
                    <div class="info-card-small">
                        <div class="info-header">
                            <div class="info-icon purple">
                                <i class="fas fa-user"></i>
                            </div>
                            <div class="info-title">نام کامل</div>
                        </div>
                        <div class="info-value">
                            <?= htmlspecialchars($user['first_name']) . ' ' . htmlspecialchars($user['last_name'] ?? '') ?>
                        </div>
                    </div>
                    
                    <div class="info-card-small">
                        <div class="info-header">
                            <div class="info-icon blue">
                                <i class="fas fa-at"></i>
                            </div>
                            <div class="info-title">نام کاربری</div>
                        </div>
                        <div class="info-value">
                            @<?= htmlspecialchars($user['username']) ?>
                        </div>
                    </div>
                    
                    <div class="info-card-small">
                        <div class="info-header">
                            <div class="info-icon green">
                                <i class="fas fa-envelope"></i>
                            </div>
                            <div class="info-title">ایمیل</div>
                        </div>
                        <div class="info-value">
                            <?= htmlspecialchars($user['email']) ?>
                        </div>
                    </div>
                </div>
                
                <!-- ردیف دوم: تاریخ تولد + جنسیت + تاریخ عضویت -->
                <div class="info-row-three">
                    <div class="info-card-small">
                        <div class="info-header">
                            <div class="info-icon <?= !empty($user['birth_date']) ? 'orange' : 'yellow' ?>">
                                <i class="<?= !empty($user['birth_date']) ? 'fas fa-birthday-cake' : 'fas fa-question-circle' ?>"></i>
                            </div>
                            <div class="info-title">تاریخ تولد</div>
                        </div>
                        <div class="info-value">
                            <?= !empty($user['birth_date']) ? date('Y/m/d', strtotime($user['birth_date'])) : 'تنظیم نشده' ?>
                        </div>
                    </div>
                    
                    <div class="info-card-small">
                        <div class="info-header">
                            <div class="info-icon pink">
                                <i class="fas fa-venus-mars"></i>
                            </div>
                            <div class="info-title">جنسیت</div>
                        </div>
                        <div class="info-value">
                            <?php
                            if (!empty($user['gender'])) {
                                switch($user['gender']) {
                                    case 'male':
                                        echo 'مرد <i class="fas fa-mars" style="color: #3b82f6; margin-right: 5px;"></i>';
                                        break;
                                    case 'female':
                                        echo 'زن <i class="fas fa-venus" style="color: #ec4899; margin-right: 5px;"></i>';
                                        break;
                                    case 'other':
                                        echo 'سایر <i class="fas fa-user" style="color: #8b5cf6; margin-right: 5px;"></i>';
                                        break;
                                }
                            } else {
                                echo 'تنظیم نشده';
                            }
                            ?>
                        </div>
                    </div>
                    
                    <div class="info-card-small">
                        <div class="info-header">
                            <div class="info-icon teal">
                                <i class="fas fa-calendar-plus"></i>
                            </div>
                            <div class="info-title">تاریخ عضویت</div>
                        </div>
                        <div class="info-value">
                            <?= date('Y/m/d', strtotime($user['created_at'])) ?>
                        </div>
                    </div>
                </div>
                
                <!-- ردیف سوم: آخرین ورود + وضعیت پروفایل -->
                <div class="info-row-two">
                    <div class="info-card-small">
                        <div class="info-header">
                            <div class="info-icon red">
                                <i class="fas fa-sign-in-alt"></i>
                            </div>
                            <div class="info-title">آخرین ورود</div>
                        </div>
                        <div class="info-value">
                            <?= date('Y/m/d H:i', strtotime($user['last_login'] ?? $user['created_at'])) ?>
                        </div>
                    </div>
                    
                    <div class="info-card-small">
                        <div class="info-header">
                            <div class="info-icon <?= $profile_complete ? 'green' : 'yellow' ?>">
                                <i class="fas fa-user-check"></i>
                            </div>
                            <div class="info-title">وضعیت پروفایل</div>
                        </div>
                        <div class="info-value">
                            <?= $profile_complete ? '<span style="color: #10b981;">تکمیل شده</span>' : '<span style="color: #f59e0b;">نیازمند تکمیل</span>' ?>
                        </div>
                    </div>
                </div>
                
                <!-- ردیف چهارم: روز عضویت + شناسه کاربری -->
                <div class="info-row-two">
                    <div class="info-card-small">
                        <div class="info-header">
                            <div class="info-icon orange">
                                <i class="fas fa-clock"></i>
                            </div>
                            <div class="info-title">روز عضویت</div>
                        </div>
                        <div class="info-value">
                            <?php 
                                $joinDate = new DateTime($user['created_at']);
                                $now = new DateTime();
                                echo $joinDate->diff($now)->days . ' روز';
                            ?>
                        </div>
                    </div>
                    
                    <div class="info-card-small">
                        <div class="info-header">
                            <div class="info-icon purple">
                                <i class="fas fa-id-card"></i>
                            </div>
                            <div class="info-title">شناسه کاربری</div>
                        </div>
                        <div class="info-value">
                            #<?= $user['id'] ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- فوتر -->
        <div class="footer-small fade-in">
            <p>داشبورد پخش زنده © <?= date('Y') ?></p>
            <div class="user-id">
                شناسه: #<?= $user['id'] ?>
            </div>
        </div>
        
        <!-- اسپیس برای نوار ابزار ثابت -->
        <div class="toolbar-spacer"></div>
    </div>
    
    <!-- نوار ابزار پایین - همیشه ثابت -->
    <div class="bottom-toolbar-fixed">
        <button class="toolbar-btn-fixed" onclick="window.location.href='edit-profile.php'">
            <i class="fas fa-user-edit"></i>
            <span>ویرایش حساب</span>
        </button>
        
        <button class="toolbar-btn-fixed" onclick="window.location.href='change-password.php'">
            <i class="fas fa-key"></i>
            <span>تغییر رمز</span>
        </button>
        
        <button class="toolbar-btn-fixed logout" onclick="logout()">
            <i class="fas fa-sign-out-alt"></i>
            <span>خروج</span>
        </button>
    </div>
    
    <script>
        // مدیریت خطای تصویر
        function handleImageError() {
            const avatarImg = document.getElementById('avatar-image');
            if (avatarImg) {
                avatarImg.style.display = 'none';
                const fallback = document.createElement('div');
                fallback.className = 'avatar-fallback';
                
                // نمایش اولین حرف نام
                const firstName = '<?= htmlspecialchars($user['first_name']) ?>';
                const initial = firstName ? firstName.charAt(0).toUpperCase() : 'U';
                fallback.textContent = initial;
                
                avatarImg.parentNode.appendChild(fallback);
                
                // سعی مجدد در بارگیری تصویر بعد از 3 ثانیه
                setTimeout(() => {
                    if (fallback.parentNode) {
                        const gender = '<?= $user['gender'] ?? '' ?>';
                        let retryUrl = '';
                        if (gender === 'female') {
                            retryUrl = 'https://entarpaltm.s2026h.space/mini/imoj/2.png';
                        } else if (gender === 'male') {
                            retryUrl = 'https://entarpaltm.s2026h.space/mini/imoj/1.png';
                        } else {
                            retryUrl = 'https://entarpaltm.s2026h.space/mini/imoj/1.png';
                        }
                        
                        avatarImg.src = retryUrl + '?retry=' + Date.now();
                        avatarImg.style.display = 'block';
                        fallback.remove();
                    }
                }, 3000);
            }
        }
        
        // بررسی تکمیل پروفایل قبل از پخش زنده
        function startLiveStream() {
            const btn = document.querySelector('.live-stream-rectangle');
            btn.style.animation = 'colorChange 0.5s infinite';
            
            // نمایش پیام
            showToast('🎬 در حال انتقال به استودیو پخش...', 'success');
            
            setTimeout(() => {
                window.location.href = 'live-stream.php';
            }, 1000);
        }
        
        // نمایش هشدار تکمیل پروفایل
        function showProfileWarning() {
            showToast('⚠️ لطفا ابتدا پروفایل خود را تکمیل کنید', 'warning');
            setTimeout(() => {
                document.querySelector('.profile-warning').scrollIntoView({
                    behavior: 'smooth',
                    block: 'center'
                });
            }, 500);
        }
        
        // مدیریت خروج
        function logout() {
            if (confirm('آیا مطمئن هستید که می‌خواهید از حساب خود خارج شوید؟')) {
                showToast('👋 در حال خروج...', 'warning');
                
                // آپدیت وضعیت آفلاین در دیتابیس
                fetch('update_online_status.php?status=offline')
                    .then(() => {
                        setTimeout(() => {
                            window.location.href = 'logout.php';
                        }, 800);
                    });
            }
        }
        
        // نمایش پیام
        function showToast(message, type = 'info') {
            const toast = document.createElement('div');
            toast.textContent = message;
            toast.style.cssText = `
                position: fixed;
                top: 20px;
                left: 50%;
                transform: translateX(-50%);
                background: ${type === 'info' ? 'var(--primary)' : 
                            type === 'success' ? 'var(--success)' : 
                            type === 'warning' ? 'var(--accent)' : 'var(--danger)'};
                color: white;
                padding: 12px 24px;
                border-radius: 50px;
                font-size: 13px;
                font-weight: 500;
                z-index: 10000;
                box-shadow: 0 8px 24px rgba(0,0,0,0.3);
                backdrop-filter: blur(10px);
                animation: slideDown 0.4s ease;
            `;
            
            document.body.appendChild(toast);
            
            setTimeout(() => {
                toast.style.animation = 'slideUp 0.4s ease';
                setTimeout(() => toast.remove(), 400);
            }, 3000);
        }
        
        // به‌روزرسانی خودکار تعداد کاربران آنلاین
        function updateOnlineUsers() {
            fetch('get_online_users.php')
                .then(response => response.json())
                .then(data => {
                    if (data.online_count !== undefined) {
                        document.getElementById('online-counter').textContent = 
                            data.online_count + ' کاربر آنلاین';
                    }
                })
                .catch(error => console.error('خطا در دریافت کاربران آنلاین:', error));
        }
        
        // ارسال ضربان آنلاین بودن
        function sendOnlinePulse() {
            fetch('update_online_status.php?status=online')
                .catch(error => console.error('خطا در ارسال ضربان:', error));
        }
        
        // انیمیشن‌های toast
        const style = document.createElement('style');
        style.textContent = `
            @keyframes slideDown {
                from {
                    transform: translateX(-50%) translateY(-100%);
                    opacity: 0;
                }
                to {
                    transform: translateX(-50%) translateY(0);
                    opacity: 1;
                }
            }
            @keyframes slideUp {
                from {
                    transform: translateX(-50%) translateY(0);
                    opacity: 1;
                }
                to {
                    transform: translateX(-50%) translateY(-100%);
                    opacity: 0;
                }
            }
        `;
        document.head.appendChild(style);
        
        // رویداد لود صفحه
        document.addEventListener('DOMContentLoaded', () => {
            // انیمیشن ورود
            setTimeout(() => {
                <?php if (!$profile_complete): ?>
                showToast('👋 برای شروع پخش زنده، لطفا پروفایل خود را تکمیل کنید', 'warning');
                <?php else: ?>
                showToast('👋 خوش آمدید ' + '<?= htmlspecialchars($user['first_name']) ?>', 'info');
                <?php endif; ?>
            }, 500);
            
            // پیش‌لود تصویر آواتار
            const avatarImg = document.getElementById('avatar-image');
            if (avatarImg) {
                const preloader = new Image();
                preloader.onload = function() {
                    console.log('تصویر آواتار با موفقیت لود شد');
                };
                preloader.onerror = function() {
                    console.log('خطا در لود تصویر آواتار');
                    handleImageError();
                };
                preloader.src = avatarImg.src;
            }
            
            // فعال‌سازی انیمیشن‌ها هنگام اسکرول
            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.style.animationPlayState = 'running';
                    }
                });
            });
            
            document.querySelectorAll('.info-card-small, .stat-card-small').forEach(el => {
                observer.observe(el);
            });
            
            // شروع تایمرهای آنلاین
            // به‌روزرسانی اولیه
            updateOnlineUsers();
            
            // به‌روزرسانی هر 30 ثانیه
            setInterval(updateOnlineUsers, 30000);
            
            // ارسال ضربان هر 60 ثانیه
            setInterval(sendOnlinePulse, 60000);
            
            // ارسال ضربان اولیه
            setTimeout(sendOnlinePulse, 1000);
            
            // به‌روزرسانی وضعیت آنلاین هنگام بسته شدن صفحه
            window.addEventListener('beforeunload', function() {
                // ارسال درخواست برای آفلاین کردن کاربر
                navigator.sendBeacon('update_online_status.php?status=offline');
            });
        });
        
        // میانبرهای صفحه‌کلید
        document.addEventListener('keydown', (e) => {
            // L برای پخش زنده (فقط اگر پروفایل کامل باشد)
            if (e.key.toLowerCase() === 'l' && <?= $profile_complete ? 'true' : 'false' ?>) {
                startLiveStream();
            }
            // E برای ویرایش پروفایل
            if (e.key.toLowerCase() === 'e') {
                window.location.href = 'edit-profile.php';
            }
            // Ctrl+Q برای خروج
            if (e.ctrlKey && e.key.toLowerCase() === 'q') {
                e.preventDefault();
                logout();
            }
        });
        
        // وضعیت آنلاین
        window.addEventListener('online', () => {
            showToast('✅ اتصال اینترنت برقرار شد', 'success');
            sendOnlinePulse();
            updateOnlineUsers();
        });
        
        window.addEventListener('offline', () => {
            showToast('⚠️ اتصال اینترنت قطع شد', 'danger');
        });
    </script>
</body>
</html>