<?php
// report_user.php
session_start();
require_once __DIR__ . '/config/database.php';

$reporter_id = $_POST['reporter_id'] ?? $_SESSION['user_id'];
$reported_id = $_POST['reported_id'] ?? '';
$reason = $_POST['reason'] ?? '';
$details = $_POST['details'] ?? '';

if (!$reporter_id || !$reported_id || !$reason) {
    echo json_encode(['success' => false, 'error' => 'Missing parameters']);
    exit;
}

$stmt = $pdo->prepare("
    INSERT INTO user_reports 
    (reporter_id, reported_id, reason, details, created_at) 
    VALUES (:reporter_id, :reported_id, :reason, :details, NOW())
");
$stmt->execute([
    'reporter_id' => $reporter_id,
    'reported_id' => $reported_id,
    'reason' => $reason,
    'details' => $details
]);

echo json_encode(['success' => true]);
?>