<?php
// select_gender.php
require_once 'config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $gender = ($_POST['gender'] == 'زن') ? 'زن' : 'مرد';
    setcookie('user_gender', $gender, time() + (86400 * 30), "/");
    header('Location: index.php');
    exit();
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>انتخاب جنسیت</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, sans-serif;
        }
        
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }
        
        .container {
            background: white;
            border-radius: 20px;
            padding: 40px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.3);
            max-width: 500px;
            width: 100%;
            text-align: center;
        }
        
        h1 {
            color: #2c3e50;
            margin-bottom: 30px;
            font-size: 28px;
        }
        
        p {
            color: #7f8c8d;
            margin-bottom: 30px;
            font-size: 16px;
            line-height: 1.6;
        }
        
        .gender-options {
            display: flex;
            gap: 20px;
            justify-content: center;
            margin-bottom: 30px;
        }
        
        .gender-option {
            flex: 1;
            padding: 20px;
            border: 2px solid #ddd;
            border-radius: 15px;
            cursor: pointer;
            transition: all 0.3s;
            text-align: center;
        }
        
        .gender-option:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0,0,0,0.1);
        }
        
        .gender-option.selected {
            border-color: #3498db;
            background: #f0f8ff;
        }
        
        .gender-option.male.selected {
            border-color: #3498db;
            background: #ebf5fb;
        }
        
        .gender-option.female.selected {
            border-color: #e84393;
            background: #fce4ec;
        }
        
        .gender-icon {
            font-size: 60px;
            margin-bottom: 10px;
        }
        
        .gender-icon.male {
            color: #3498db;
        }
        
        .gender-icon.female {
            color: #e84393;
        }
        
        .gender-name {
            font-size: 20px;
            font-weight: bold;
            color: #2c3e50;
        }
        
        .btn {
            background: #2ecc71;
            color: white;
            border: none;
            padding: 15px 40px;
            font-size: 18px;
            border-radius: 10px;
            cursor: pointer;
            transition: all 0.3s;
            display: inline-flex;
            align-items: center;
            gap: 10px;
        }
        
        .btn:hover {
            background: #27ae60;
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(0,0,0,0.2);
        }
        
        .btn:disabled {
            background: #95a5a6;
            cursor: not-allowed;
            transform: none;
            box-shadow: none;
        }
        
        .info-box {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 10px;
            margin-top: 20px;
            font-size: 14px;
            color: #7f8c8d;
            border-right: 4px solid #3498db;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1><i class="fas fa-venus-mars"></i> انتخاب جنسیت</h1>
        <p>لطفا جنسیت خود را انتخاب کنید تا شریک مناسب برای شما پیدا شود.</p>
        
        <form method="POST" id="genderForm">
            <div class="gender-options">
                <div class="gender-option male" onclick="selectGender('male')">
                    <div class="gender-icon male">
                        <i class="fas fa-mars"></i>
                    </div>
                    <div class="gender-name">مرد</div>
                </div>
                
                <div class="gender-option female" onclick="selectGender('female')">
                    <div class="gender-icon female">
                        <i class="fas fa-venus"></i>
                    </div>
                    <div class="gender-name">زن</div>
                </div>
            </div>
            
            <input type="hidden" name="gender" id="selectedGender" value="">
            
            <button type="submit" class="btn" id="submitBtn" disabled>
                <i class="fas fa-check-circle"></i> ادامه
            </button>
        </form>
        
        <div class="info-box">
            <i class="fas fa-info-circle"></i>
            انتخاب جنسیت به سیستم کمک می‌کند تا شریک مناسب‌تری برای شما پیدا کند.
        </div>
    </div>
    
    <script>
        let selectedGender = '';
        
        function selectGender(gender) {
            selectedGender = gender;
            
            document.querySelectorAll('.gender-option').forEach(option => {
                option.classList.remove('selected');
            });
            
            const selectedOption = document.querySelector(`.gender-option.${gender}`);
            selectedOption.classList.add('selected');
            
            document.getElementById('selectedGender').value = 
                gender === 'male' ? 'مرد' : 'زن';
            
            document.getElementById('submitBtn').disabled = false;
        }
    </script>
</body>
</html>