<?php
// update_search_status.php
session_start();
require_once __DIR__ . '/config/database.php';

// بررسی session
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'error' => 'User not logged in']);
    exit;
}

$user_id = $_SESSION['user_id'];
$is_searching = isset($_POST['is_searching']) ? (int)$_POST['is_searching'] : 0;
$is_online = isset($_POST['is_online']) ? (int)$_POST['is_online'] : 1;

try {
    $sql = "UPDATE users SET is_searching = ?, is_online = ?, last_activity = NOW() WHERE id = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$is_searching, $is_online, $user_id]);
    $stmt->closeCursor();
    
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode(['success' => true, 'message' => 'Status updated']);
    
} catch (PDOException $e) {
    error_log("Database error in update_search_status.php: " . $e->getMessage());
    
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode(['success' => false, 'error' => 'Database error']);
}
?>